/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketSendServerCommand {
    private final String modid;
    private final String command;
    private final TypedMap arguments;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.modid);
        buf.m_130070_(this.command);
        TypedMapTools.writeArguments(buf, this.arguments);
    }

    public PacketSendServerCommand(FriendlyByteBuf buf) {
        this.modid = buf.m_130136_(Short.MAX_VALUE);
        this.command = buf.m_130136_(Short.MAX_VALUE);
        this.arguments = TypedMapTools.readArguments(buf);
    }

    public PacketSendServerCommand(String modid, String command, @Nonnull TypedMap arguments) {
        this.modid = modid;
        this.command = command;
        this.arguments = arguments;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            boolean result = McJtyLib.handleCommand(this.modid, this.command, (Player)ctx.getSender(), this.arguments);
            if (!result) {
                Logging.logError("Error handling command '" + this.command + "' for mod '" + this.modid + "'!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

